package ru.yandex.bannerstorage.harvester.infrastructure;

import java.util.Objects;

import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

/**
 * @author egorovmv
 */
public class MonitoringProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoringProvider.class);

    private final JdbcTemplate jdbcTemplate;

    public MonitoringProvider(@NotNull JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate, "jdbcTemplate");
    }

    public boolean test() {
        try {
            jdbcTemplate.execute("SELECT 1");
            return true;
        } catch (Exception e) {
            LOGGER.error("Can't execute test", e);
            return false;
        }
    }
}
