package ru.yandex.bannerstorage.harvester.integration.direct;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import static java.util.stream.Collectors.toList;

/**
 * Просто моделька для передачи номеров креативов в intapi Директа
 *
 * Пример в json: {"method":"change_notify","params":{"creatives":[{"id":1},{"id":2},{"id":3}]}}
 */
public class CreativeChangedRequest {
    @JsonProperty("method")
    private final String method;
    @JsonProperty("params")
    private final Params params;

    public CreativeChangedRequest(List<Integer> creativeIds) {
        method = "change_notify";
        params = new Params(creativeIds.stream().map(Params.Creative::new).collect(toList()));
    }

    public String getMethod() {
        return method;
    }

    public Params getParams() {
        return params;
    }

    public static class Params {
        @JsonProperty("creatives")
        private final List<Creative> creatives;

        public Params(List<Creative> creatives) {
            this.creatives = creatives;
        }

        public List<Creative> getCreatives() {
            return creatives;
        }

        public static class Creative {
            @JsonProperty("id")
            private final int id;

            public Creative(int id) {
                this.id = id;
            }

            public int getId() {
                return id;
            }
        }
    }
}
