package ru.yandex.bannerstorage.harvester.integration.stillage;

import java.net.URI;
import java.net.URISyntaxException;

import javax.validation.constraints.NotNull;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import static java.util.Objects.requireNonNull;


/**
 * @author skirsanov
 */
public class StillageClient {

    private static final Logger logger = LoggerFactory.getLogger(StillageClient.class);

    private static final String UPLOAD_FILES_PATH = "/api/v1/files/content/bin";

    private final String stillageUrl;
    private final RestTemplate restTemplate;


    public StillageClient(@NotNull final String stillageUrl) {
        this.stillageUrl = requireNonNull(stillageUrl);
        this.restTemplate = new RestTemplate();
    }

    /**
     * Uploads file to Stillage
     *
     * @param fileName some name for a file
     * @param body     data of the file
     * @return public URL to access that file
     * @throws URISyntaxException if stillageUrl is malformed
     */
    public StillageAnswer uploadFile(@NotNull final String fileName, @NotNull final byte[] body) {
        final URI requestUri = UriComponentsBuilder.fromHttpUrl(stillageUrl)
                .path(UPLOAD_FILES_PATH)
                .queryParam("fileName", fileName)
                .build()
                .toUri();

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);

        logger.info("Executing request \"{}\"", requestUri);

        return restTemplate.postForObject(requestUri,
                new HttpEntity<>(body, headers),
                StillageAnswer.class);
    }
}
