package ru.yandex.bannerstorage.harvester.queues;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.bannerstorage.harvester.queues.rtbintegration.creativechanged.CreativeChangedMessage;
import ru.yandex.bannerstorage.harvester.queues.rtbintegration.creativechanged.CreativeChangedQueueObserver;
import ru.yandex.bannerstorage.harvester.queues.rtbintegration.creativechanged.CreativeChangedRequest;
import ru.yandex.bannerstorage.harvester.queues.rtbintegration.creativechanged.services.CreativeService;
import ru.yandex.bannerstorage.harvester.queues.rtbintegration.infrastructure.RtbClientService;
import ru.yandex.bannerstorage.harvester.queues.rtbintegration.infrastructure.RtbIntegrationHealthService;
import ru.yandex.bannerstorage.harvester.queues.rtbintegration.infrastructure.impl.BsApiClientService;
import ru.yandex.direct.bs.dspcreative.service.DspCreativeYtExporter;

import static java.util.stream.Collectors.toList;

public class CreativeSendToRTBHostTaskProcessor implements ITaskProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CreativeSendToRTBHostTaskProcessor.class);

    private final CreativeChangedQueueObserver creativeChangedQueueObserver;
    private final ExecutorService executorService;
    private final int countOfThreads;

    public CreativeSendToRTBHostTaskProcessor(CreativeService creativeService,
                                              RtbClientService rtbClientService,
                                              DspCreativeYtExporter dspCreativeYtExporter,
                                              RtbIntegrationHealthService healthService,
                                              BsApiClientService bsApiClientService,
                                              int countOfThreads) {
        this.creativeChangedQueueObserver = new CreativeChangedQueueObserver(
                creativeService, rtbClientService, healthService, bsApiClientService, dspCreativeYtExporter);
        this.countOfThreads = countOfThreads;
        this.executorService = Executors.newFixedThreadPool(
                countOfThreads,
                new ThreadFactoryBuilder()
                        .setNameFormat("CreativeSendToRTBHostTaskProcessor-thread-%d")
                        .build()
        );
    }


    @Override
    public void process(List<ITask> tasks) {
        List<CreativeChangedRequest> creativeChangedRequests = tasks.stream().map(
                task -> {
                    List<Integer> creativeVersions =
                            Stream.of(task.getData().split(",")).map(Integer::parseInt).collect(toList());
                    CreativeChangedRequest creativeChangedRequest = new CreativeChangedRequest();
                    creativeChangedRequest.setCreativeVersions(
                            creativeVersions.stream()
                                    .map(creativeVersionId -> {
                                        CreativeChangedMessage creativeChangedMessage = new CreativeChangedMessage();
                                        creativeChangedMessage.setCreativeVersionId(creativeVersionId);
                                        creativeChangedMessage.setOrderNo(1);
                                        return creativeChangedMessage;
                                    })
                                    .collect(toList())
                    );
                    return creativeChangedRequest;
                })
                .collect(toList());

        CompletableFuture.allOf(
                creativeChangedRequests.stream()
                        .map(message -> CompletableFuture.runAsync(
                                () -> creativeChangedQueueObserver.doProcessMessage(message),
                                executorService))
                        .toArray(CompletableFuture[]::new)).join(); // IGNORE-BAD-JOIN DIRECT-149116
    }
}
