package ru.yandex.bannerstorage.harvester.queues.automoderation;

import java.util.Objects;

import org.jetbrains.annotations.NotNull;

import ru.yandex.bannerstorage.harvester.queues.automoderation.models.AutoModerationNotifyRequest;
import ru.yandex.bannerstorage.harvester.queues.automoderation.services.CreativeService;
import ru.yandex.bannerstorage.messaging.services.QueueMessageOnErrorStrategy;
import ru.yandex.bannerstorage.messaging.services.SimpleOneWayQueueObserver;

/**
 * Очередь для отправки уведомлений об отклоненных креативах
 *
 * @author egorovmv
 */
public final class AutoModerationNotifyQueueObserver extends SimpleOneWayQueueObserver<AutoModerationNotifyRequest> {
    public static final String SERVICE_ID = "AutoModerationNotifyService";
    private static final String QUEUE_ID = "dbo.AutoModerationNotifyServiceQueue";

    private final CreativeService creativeService;

    public AutoModerationNotifyQueueObserver(
            @NotNull CreativeService creativeService, int pollIntervalInMS) {
        super(
                QUEUE_ID,
                pollIntervalInMS,
                5,
                5,
                QueueMessageOnErrorStrategy.INFINITE_POISON_START_NEW_SESSION,
                AutoModerationNotifyRequest.class);
        this.creativeService = Objects.requireNonNull(creativeService, "creativeService");
    }

    @Override
    protected void doProcessMessage(@NotNull AutoModerationNotifyRequest message) {
        Integer creativeVersionId = message.getCreativeVersionId();

        if (message.isWasApprovedByModerator() || creativeService.hasAnyPrevVersionSentToBk(creativeVersionId))
            creativeService.notifyBk(creativeVersionId);

        creativeService.notifyCustomer(creativeVersionId);
    }
}
