package ru.yandex.bannerstorage.harvester.queues.automoderation.models;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Сообщение на уведомление о завершении процесса автомоддерации для данной версии креатива (очередь AutoModerationNotifyQueue)
 *
 * @author egorovmv
 */
@XmlRootElement(name = "creative_version")
@XmlAccessorType(XmlAccessType.FIELD)
public final class AutoModerationNotifyRequest {
    /**
     * Номер версии креатива
     */
    @XmlAttribute(name = "id")
    private int creativeVersionId;
    /**
     * Была ли уже принята данная версия креатива модераторатором
     */
    @XmlAttribute(name = "wasApproved")
    private boolean wasApprovedByModerator;

    /**
     * Для сериализации
     */
    private AutoModerationNotifyRequest() {
    }

    public AutoModerationNotifyRequest(int creativeVersionId, boolean wasApprovedByModerator) {
        this.creativeVersionId = creativeVersionId;
        this.wasApprovedByModerator = wasApprovedByModerator;
    }

    @Override
    public String toString() {
        return "AutoModerationNotifyRequest{" +
                "creativeVersionId=" + creativeVersionId +
                ", wasApprovedByModerator=" + wasApprovedByModerator +
                '}';
    }

    public int getCreativeVersionId() {
        return creativeVersionId;
    }

    public void setCreativeVersionId(int creativeVersionId) {
        this.creativeVersionId = creativeVersionId;
    }

    public boolean isWasApprovedByModerator() {
        return wasApprovedByModerator;
    }

    public void setWasApprovedByModerator(boolean wasApprovedByModerator) {
        this.wasApprovedByModerator = wasApprovedByModerator;
    }
}
