package ru.yandex.bannerstorage.harvester.queues.automoderation.models;

import java.util.Collections;
import java.util.Set;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Сообщение на запуск процесса автомодерации для креатива (очередь AutoModerationStartQueue)
 *
 * @author egorovmv
 */
@XmlRootElement(name = "creative_version")
@XmlAccessorType(XmlAccessType.FIELD)
public final class AutoModerationStartRequest {
    /**
     * Номер версии креатива
     */
    @XmlAttribute(name = "id")
    private int creativeVersionId;

    /**
     * Номера проверок которые необходимо выполнить (из таблицы dbo.t_automoderation_check)
     */
    @XmlElement(name = "check")
    private Set<Integer> requiredChecks;

    @Override
    public String toString() {
        return "AutoModerationStartRequest{" +
                "creativeVersionId=" + creativeVersionId +
                ", requiredChecks=" + requiredChecks +
                '}';
    }

    public int getCreativeVersionId() {
        return creativeVersionId;
    }

    public void setCreativeVersionId(int creativeVersionId) {
        this.creativeVersionId = creativeVersionId;
    }

    public Set<Integer> getRequiredChecks() {
        return requiredChecks != null ? requiredChecks : Collections.emptySet();
    }

    public void setRequiredChecks(Set<Integer> requiredChecks) {
        this.requiredChecks = requiredChecks;
    }
}
