package ru.yandex.bannerstorage.harvester.queues.automoderation.services.models;

import java.util.Objects;

import org.jetbrains.annotations.NotNull;

/**
 * Базовый класс для постановки заданий на автомодерацию/результата автомодерации креатива
 *
 * @author egorovmv
 */
public abstract class AbstractTask {
    /**
     * Креатив для автомодерации
     */
    protected final Creative creative;

    public AbstractTask(@NotNull Creative creative) {
        this.creative = Objects.requireNonNull(creative, "creative");
    }

    public Creative getCreative() {
        return creative;
    }
}
