package ru.yandex.bannerstorage.harvester.queues.automoderation.services.models;

import java.util.Map;
import java.util.Objects;

import org.jetbrains.annotations.NotNull;

/**
 * Запрашиваемая проверка
 *
 * @author elwood
 */
public final class Check {
    /**
     * Название проверки
     */
    private final String name;
    /**
     * Параметры с которыми надо производить проверку
     */
    private final Map<String, Object> options;

    public Check(@NotNull String name, @NotNull Map<String, Object> options) {
        this.name = Objects.requireNonNull(name, "name");
        this.options = Objects.requireNonNull(options, "options");
    }

    @Override
    public String toString() {
        return "Check{" +
                "name='" + name + '\'' +
                ", options=" + options +
                '}';
    }

    public String getName() {
        return name;
    }

    public Map<String, Object> getOptions() {
        return options;
    }
}
