package ru.yandex.bannerstorage.harvester.queues.automoderation.services.models;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

/**
 * Результат автомодерации для заданной проверки
 *
 * @author elwood
 */
public final class CheckResult {
    /**
     * Название проверки
     */
    private final String name;
    /**
     * Параметры с которыми надо производить проверку
     */
    private final Map<String, Object> options;
    /**
     * Текущее состояние
     */
    private final CheckResultStatus status;
    /**
     * Дата начала проверки
     */
    private final ZonedDateTime started;
    /**
     * Дата окончания проверки
     */
    private final ZonedDateTime finished;
    /**
     * Результаты заданной проверки
     */
    private final List<Map<String, Object>> results;

    @JsonCreator
    public CheckResult(
            @NotNull @JsonProperty("name") String name,
            @NotNull @JsonProperty("options") Map<String, Object> options,
            @NotNull @JsonProperty("status") CheckResultStatus status,
            @JsonProperty("started") ZonedDateTime started,
            @JsonProperty("finished") ZonedDateTime finished,
            @NotNull @JsonProperty("results") List<Map<String, Object>> results) {
        this.name = Objects.requireNonNull(name, "name");
        this.options = Objects.requireNonNull(options, "options");
        this.status = Objects.requireNonNull(status, "status");
        this.started = started;
        this.finished = finished;
        this.results = Objects.requireNonNull(results, "results");
    }

    @Override
    public String toString() {
        return "CheckResult{" +
                "name='" + name + '\'' +
                ", options=" + options +
                ", status=" + status +
                ", started=" + started +
                ", finished=" + finished +
                ", results=" + results +
                '}';
    }

    public String getName() {
        return name;
    }

    public Map<String, Object> getOptions() {
        return options;
    }

    public CheckResultStatus getStatus() {
        return status;
    }

    public ZonedDateTime getStarted() {
        return started;
    }

    public ZonedDateTime getFinished() {
        return finished;
    }

    public List<Map<String, Object>> getResults() {
        return results;
    }
}
