package ru.yandex.bannerstorage.harvester.queues.automoderation.services.models;

/**
 * Статус завершения проверки
 *
 * @author egorovmv
 */
public enum CheckResultStatus {
    CREATED, // Проверка была создана, но еще не запущена
    RUNNING, // Проверка была запущена
    BAD_OPTIONS, // Проверка завершлилась с ошибкой, так как были переданы неправильные параметры
    ERROR, // Проверка завершилась с ошибкой, так как по какой-то причине отведенных попыток не хватило
    FAILED, // Проверка провалилась, обнаружено наружение
    PASSED; // Проверка успешно пройдена

    public boolean isError() {
        return this == BAD_OPTIONS || this == ERROR;
    }

    public boolean isCompletion() {
        return this == BAD_OPTIONS || this == ERROR || this == FAILED || this == PASSED;
    }
}
