package ru.yandex.bannerstorage.harvester.queues.automoderation.services.models;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Креатив для автомодерации
 *
 * @author egorovmv
 */
public final class Creative {
    /**
     * Рабочий код креатива
     */
    @Nullable
    private final String code;
    /**
     * Файлы креатива
     */
    @NotNull
    private final List<CreativeFile> files;

    /**
     * Параметры креатива
     */
    @NotNull
    private final List<CreativeParamValue> values;

    @JsonCreator
    public Creative(
            @Nullable @JsonProperty("code") String code,
            @NotNull @JsonProperty("files") List<CreativeFile> files,
            @NotNull @JsonProperty("values") List<CreativeParamValue> values) {
        this.code = code;
        this.files = Objects.requireNonNull(files, "files");
        this.values = values;
    }

    @Override
    public String toString() {
        return "Creative{" +
                "code='" + code + '\'' +
                ", files=" + files +
                '}';
    }

    @Nullable
    public String getCode() {
        return code;
    }

    @NotNull
    public List<CreativeFile> getFiles() {
        return files;
    }

    @NotNull
    public List<CreativeParamValue> getValues() {
        return values;
    }
}
