package ru.yandex.bannerstorage.harvester.queues.automoderation.services.models;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

/**
 * Файл креатива
 *
 * @author elwood
 */
public class CreativeFile {
    /**
     * Идентификатор файла
     */
    private final String id;
    /**
     * Md5-хеш файла
     */
    private final String md5;
    /**
     * Локальный путь к файлу (для HTML5)
     */
    private final String path;
    /**
     * Url содержимого файла
     */
    private final String contentUrl;

    @JsonCreator
    public CreativeFile(
            @NotNull @JsonProperty("id") String id,
            @NotNull @JsonProperty("md5") String md5,
            @NotNull @JsonProperty("path") String path,
            @NotNull @JsonProperty("contentUrl") String contentUrl) {
        this.id = Objects.requireNonNull(id, "id");
        this.md5 = Objects.requireNonNull(md5, "md5");
        this.path = Objects.requireNonNull(path, "path");
        this.contentUrl = Objects.requireNonNull(contentUrl, "contentUrl");
    }

    @Override
    public String toString() {
        return "CreativeFile{" +
                "id='" + id + '\'' +
                ", md5='" + md5 + '\'' +
                ", path='" + path + '\'' +
                ", contentUrl=" + contentUrl +
                '}';
    }

    public String getId() {
        return id;
    }

    public String getMd5() {
        return md5;
    }

    public String getPath() {
        return path;
    }

    public String getContentUrl() {
        return contentUrl;
    }
}
