package ru.yandex.bannerstorage.harvester.queues.automoderation.services.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreativeParamValue {

    @NotNull
    private final String paramName;

    @Nullable
    private final String paramValue;

    @Nullable
    private final Integer rowNum;

    @NotNull
    private final String paramType;

    @JsonCreator
    public CreativeParamValue(@NotNull @JsonProperty("paramName") String paramName,
                              @Nullable @JsonProperty("paramValue") String paramValue,
                              @Nullable @JsonProperty("rowNum") Integer rowNum,
                              @NotNull @JsonProperty("paramType") String paramType) {
        this.paramName = paramName;
        this.paramValue = paramValue;
        this.rowNum = rowNum;
        this.paramType = paramType;
    }

    @NotNull
    public String getParamName() {
        return paramName;
    }

    @Nullable
    public String getParamValue() {
        return paramValue;
    }

    @Nullable
    public Integer getRowNum() {
        return rowNum;
    }

    @NotNull
    public String getParamType() {
        return paramType;
    }
}
