package ru.yandex.bannerstorage.harvester.queues.automoderation.services.models;

import java.util.List;
import java.util.Objects;

import org.jetbrains.annotations.NotNull;

/**
 * Задание на автомодерацию креатива
 *
 * @author egorovmv
 */
public final class TaskDefinition extends AbstractTask {
    /**
     * Требуемые для креатива проверки в ходе автомодерации
     */
    private final List<Check> checks;

    public TaskDefinition(@NotNull Creative creative, @NotNull List<Check> checks) {
        super(creative);
        this.checks = Objects.requireNonNull(checks, "checks");
    }

    @Override
    public String toString() {
        return "TaskDefinition{" +
                "creative='" + creative + '\'' +
                ", checks=" + checks +
                '}';
    }

    public List<Check> getChecks() {
        return checks;
    }
}
