package ru.yandex.bannerstorage.harvester.queues.automoderation.services.virustotal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author egorovmv
 */
public final class VirusTotalAntiVirusScanResult {
    private final boolean detected;
    private final String version;
    private final String result;
    private final String update;

    @JsonCreator
    public VirusTotalAntiVirusScanResult(
            @JsonProperty("detected") boolean detected,
            @JsonProperty("version") String version,
            @JsonProperty("update") String update,
            @JsonProperty("result") String result) {
        this.detected = detected;
        this.version = version;
        this.update = update;
        this.result = result;
    }

    @Override
    public String toString() {
        return "VirusTotalAntiVirusScanResult{" +
                "detected=" + detected +
                ", version='" + version + '\'' +
                ", update='" + update + '\'' +
                ", result='" + result + '\'' +
                '}';
    }

    public boolean isDetected() {
        return detected;
    }

    public String getVersion() {
        return version;
    }

    public String getUpdate() {
        return update;
    }

    public String getResult() {
        return result;
    }
}
