package ru.yandex.bannerstorage.harvester.queues.automoderation.services.virustotal;

import java.net.URI;
import java.util.List;
import java.util.Map;

import org.jetbrains.annotations.NotNull;

/**
 * @author egorovmv
 */
public interface VirusTotalClient {
    /**
     * Получить состояние проверки файлов по их md5 хешам
     *
     * @param resourceIds Список md5 хешей файлов или список идентификаторов сканирования
     * @return Результаты проверки по файлам
     */
    Map<String, VirusTotalScanResult> getScanResult(@NotNull List<String> resourceIds);

    /**
     * Отправить файл на проверку
     *
     * @param fileUrl Url файла
     * @return null в случае невалидного url-а, иначе результат постановки файла в очередь на проверку
     */
    VirusTotalSendScanResult sendForScan(@NotNull String fileName, @NotNull URI fileUrl);

    /**
     * Переотправить файлы на проверку по их md5 хешам
     *
     * @param md5Hashes Список md5 хешей файлов
     * @return Результаты поставновки файлов в очередь на проверку
     */
    Map<String, VirusTotalSendScanResult> sendForRescanByMd5Hashes(@NotNull List<String> md5Hashes);
}
