package ru.yandex.bannerstorage.harvester.queues.automoderation.services.virustotal;

/**
 * Базовый класс для ответов VirusTotal
 *
 * @author egorovmv
 */
public abstract class VirusTotalResponse {
    /**
     * 0 - не найдено, 1 - успех, 2 - ошибка
     */
    protected final int responseCode;
    /**
     * Расшифровка кода
     */
    protected final String responseMessage;
    protected final String resource;
    protected final String scanId;
    protected final String permalink;
    protected final String sha256;
    protected final String sha1;
    protected final String md5;

    protected VirusTotalResponse(
            int responseCode,
            String responseMessage,
            String resource,
            String scanId,
            String permalink,
            String sha256,
            String sha1,
            String md5) {
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.resource = resource;
        this.scanId = scanId;
        this.permalink = permalink;
        this.sha256 = sha256;
        this.sha1 = sha1;
        this.md5 = md5;
    }

    public final int getResponseCode() {
        return responseCode;
    }

    public final String getResponseMessage() {
        return responseMessage;
    }

    public String getResource() {
        return resource;
    }

    public String getScanId() {
        return scanId;
    }

    public String getPermalink() {
        return permalink;
    }

    public String getSha256() {
        return sha256;
    }

    public String getSha1() {
        return sha1;
    }

    public String getMd5() {
        return md5;
    }

    public final boolean isNotFound() {
        return responseCode == 0;
    }

    public final boolean isSuccess() {
        return responseCode == 1;
    }

    public final boolean isError() {
        return responseCode == 2;
    }
}
