package ru.yandex.bannerstorage.harvester.queues.automoderation.services.virustotal;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Результат сканирования файла
 *
 * @author egorovmv
 */
public final class VirusTotalScanResult extends VirusTotalResponse {
    private final String scanDate;
    private final int positiveCount;
    private final int totalCount;
    private final Map<String, VirusTotalAntiVirusScanResult> scans;

    @JsonCreator
    public VirusTotalScanResult(
            @JsonProperty("response_code") int responseCode,
            @JsonProperty("verbose_msg") String responseMessage,
            @JsonProperty("resource") String resource,
            @JsonProperty("scan_id") String scanId,
            @JsonProperty("permalink") String permalink,
            @JsonProperty("sha256") String sha256,
            @JsonProperty("sha1") String sha1,
            @JsonProperty("md5") String md5,
            @JsonProperty("scan_date") String scanDate,
            @JsonProperty("positives") int positiveCount,
            @JsonProperty("total") int totalCount,
            @JsonProperty("scans") Map<String, VirusTotalAntiVirusScanResult> scans) {
        super(responseCode, responseMessage, resource, scanId, permalink, sha256, sha1, md5);
        this.scanDate = scanDate;
        this.positiveCount = positiveCount;
        this.totalCount = totalCount;
        this.scans = scans;
    }

    @Override
    public String toString() {
        return "VirusTotalSendScanResult{" +
                "responseCode='" + responseCode + '\'' +
                ", responseMessage='" + responseMessage + '\'' +
                ", resource='" + resource + '\'' +
                ", scanId='" + scanId + '\'' +
                ", permalink='" + permalink + '\'' +
                ", sha256='" + sha256 + '\'' +
                ", sha1='" + sha1 + '\'' +
                ", md5='" + md5 + '\'' +
                ", scanDate='" + scanDate + '\'' +
                ", positiveCount=" + positiveCount +
                ", totalCount=" + totalCount +
                ", scans=" + scans +
                '}';
    }

    public String getScanDate() {
        return scanDate;
    }

    public int getPositiveCount() {
        return positiveCount;
    }

    public int getTotalCount() {
        return totalCount;
    }

    public Map<String, VirusTotalAntiVirusScanResult> getScans() {
        return scans;
    }
}
