package ru.yandex.bannerstorage.harvester.queues.automoderation.services.virustotal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Результат отправки на файла на сканирование
 *
 * @author egorovmv
 */
public final class VirusTotalSendScanResult extends VirusTotalResponse {
    @JsonCreator
    protected VirusTotalSendScanResult(
            @JsonProperty("response_code") int responseCode,
            @JsonProperty("verbose_msg") String responseMessage,
            @JsonProperty("resource") String resource,
            @JsonProperty("scan_id") String scanId,
            @JsonProperty("permalink") String permalink,
            @JsonProperty("sha256") String sha256,
            @JsonProperty("sha1") String sha1,
            @JsonProperty("md5") String md5) {
        super(responseCode, responseMessage, resource, scanId, permalink, sha256, sha1, md5);
    }

    @Override
    public String toString() {
        return "VirusTotalSendScanResult{" +
                "responseCode='" + responseCode + '\'' +
                ", responseMessage='" + responseMessage + '\'' +
                ", resource='" + resource + '\'' +
                ", scanId='" + scanId + '\'' +
                ", permalink='" + permalink + '\'' +
                ", sha256='" + sha256 + '\'' +
                ", sha1='" + sha1 + '\'' +
                ", md5='" + md5 + '\'' +
                '}';
    }
}
