package ru.yandex.bannerstorage.harvester.queues.processdynamiccode;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.NodeVisitor;

import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.infrastracture.ImageStorageService;
import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.processors.ElementProcessor;
import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.processors.ElementWithForbiddenExternalUriProcessor;
import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.processors.ElementWithStyleAttributeProcessor;
import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.processors.ImgElementProcessor;
import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.processors.ScriptElementProcessor;
import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.processors.StyleElementProcessor;

/**
 * @author egorovmv
 */
final class HtmlCodeFileProcessor {
    private final List<ElementProcessor> allElementProcessors = new ArrayList<>();
    private final Map<String, ElementProcessor> elementProcessorsByTag = new TreeMap<>(String.CASE_INSENSITIVE_ORDER);

    public HtmlCodeFileProcessor() {
        allElementProcessors.add(new ElementWithStyleAttributeProcessor());

        elementProcessorsByTag.put(
                "img", new ImgElementProcessor());
        elementProcessorsByTag.put(
                "link", new ElementWithForbiddenExternalUriProcessor("href"));
        elementProcessorsByTag.put(
                "style", new StyleElementProcessor());
        elementProcessorsByTag.put(
                "script", new ScriptElementProcessor());
    }

    private void processNode(Node node, ImageStorageService.ImageUploader imageUploader) {
        if (!(node instanceof Element))
            return;
        Element element = (Element) node;
        for (ElementProcessor elementProcessor : allElementProcessors) {
            elementProcessor.processElement(element, imageUploader);
        }
        ElementProcessor elementProcessor = elementProcessorsByTag.get(element.nodeName());
        if (elementProcessor != null)
            elementProcessor.processElement(element, imageUploader);
    }

    public void processDocument(@NotNull Document document, @NotNull ImageStorageService.ImageUploader imageUploader) {
        document.traverse(new NodeVisitor() {
            @Override
            public void head(Node node, int depth) {
            }

            @Override
            public void tail(Node node, int depth) {
                HtmlCodeFileProcessor.this.processNode(node, imageUploader);
            }
        });
    }
}
