package ru.yandex.bannerstorage.harvester.queues.processdynamiccode;

import java.util.Objects;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.jetbrains.annotations.NotNull;

/**
 * @author egorovmv
 */
@XmlRootElement(name = "creative_version")
@XmlAccessorType(XmlAccessType.FIELD)
public final class ProcessDynamicCodeResponse {
    @XmlAttribute(name = "id")
    private int creativeVersionId;
    @XmlAttribute(name = "subVersionId")
    private int creativeVersionSubVersionId;
    @XmlAttribute(name = "is_success")
    private boolean isSuccess;
    @XmlAttribute(name = "processed_code_file_id")
    private Integer processedCodeFileId;
    @XmlElement(name = "reject_code")
    private String rejectCode;
    @XmlElement(name = "reject_details")
    private String rejectDetails;

    private ProcessDynamicCodeResponse() {
    }

    public static ProcessDynamicCodeResponse success(
            int creativeVersionId,
            int creativeVersionSubVersionId,
            @NotNull Integer processedCodeFileId) {
        Objects.requireNonNull(processedCodeFileId, "processedCodeFileId");

        ProcessDynamicCodeResponse result = new ProcessDynamicCodeResponse();
        result.setCreativeVersionId(creativeVersionId);
        result.setCreativeVersionSubVersionId(creativeVersionSubVersionId);
        result.setSuccess(true);
        result.setProcessedCodeFileId(processedCodeFileId);

        return result;
    }

    public static ProcessDynamicCodeResponse error(
            int creativeVersionId,
            int creativeVersionSubVersionId,
            @NotNull String rejectCode,
            @NotNull String rejectDetails) {
        ProcessDynamicCodeResponse result = new ProcessDynamicCodeResponse();

        result.setCreativeVersionId(creativeVersionId);
        result.setCreativeVersionSubVersionId(creativeVersionSubVersionId);
        result.setSuccess(false);
        result.setRejectCode(rejectCode);
        result.setRejectDetails(rejectDetails);

        return result;
    }

    public int getCreativeVersionId() {
        return creativeVersionId;
    }

    public void setCreativeVersionId(int creativeVersionId) {
        this.creativeVersionId = creativeVersionId;
    }

    public int getCreativeVersionSubVersionId() {
        return creativeVersionSubVersionId;
    }

    public void setCreativeVersionSubVersionId(int creativeVersionSubVersionId) {
        this.creativeVersionSubVersionId = creativeVersionSubVersionId;
    }

    public boolean isSuccess() {
        return isSuccess;
    }

    public void setSuccess(boolean success) {
        isSuccess = success;
    }

    public Integer getProcessedCodeFileId() {
        return processedCodeFileId;
    }

    public void setProcessedCodeFileId(Integer processedCodeFileId) {
        this.processedCodeFileId = processedCodeFileId;
    }

    public String getRejectCode() {
        return rejectCode;
    }

    public void setRejectCode(String rejectCode) {
        this.rejectCode = rejectCode;
    }

    public String getRejectDetails() {
        return rejectDetails;
    }

    public void setRejectDetails(String rejectDetails) {
        this.rejectDetails = rejectDetails;
    }
}
