package ru.yandex.bannerstorage.harvester.queues.processdynamiccode.infrastracture.impl;

import org.jetbrains.annotations.NotNull;
import org.springframework.web.util.UriComponentsBuilder;

/**
 * @author egorovmv
 */
public final class DevNullImageStorageService extends AbstractImageStorageService {
    @Override
    public ImageUploader createUploader() {
        return new DevNullImageUploader();
    }

    private static class DevNullImageUploader extends AbstractImageUploader {
        @NotNull
        @Override
        public String doUploadImage(@NotNull String originalImageUrl) {
            return UriComponentsBuilder.fromHttpUrl(originalImageUrl)
                    .host("avatars.yandex.ru")
                    .build()
                    .toString();
        }
    }
}
