package ru.yandex.bannerstorage.harvester.queues.processdynamiccode.processors;

import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;

import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.infrastracture.ImageStorageService;

/**
 * @author egorovmv
 */
public abstract class ElementProcessor {
    protected static boolean isRelativeUrl(@NotNull String url) {
        return !url.startsWith("http:") && !url.startsWith("https:") && !url.startsWith("//");
    }

    public abstract void processElement(
            @NotNull Element element, @NotNull ImageStorageService.ImageUploader imageUploader);
}
