package ru.yandex.bannerstorage.harvester.queues.processdynamiccode.processors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.jetbrains.annotations.NotNull;

import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.exceptions.RelativeUriNotSupportedException;
import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.infrastracture.ImageStorageService;

/**
 * @author egorovmv
 */
abstract class ElementWithCssProcessor extends ElementProcessor {
    // TODO: Cледует доработать regexp так как по RFC-3986 в url-ле могут встречаться и ' и "
    private static final Pattern SOMETHING_LIKE_CSS_URL_PATTERN = Pattern.compile(
            "url\\s*\\(\\s*((:?'|\")?)([^\\s'\")]+)\\1\\s*\\)");

    static String processCss(
            @NotNull String oldCss, @NotNull ImageStorageService.ImageUploader imageUploader) {
        Matcher matcher = SOMETHING_LIKE_CSS_URL_PATTERN.matcher(oldCss);
        StringBuffer newCss = new StringBuffer(oldCss.length()); // Используется StringBuffer так как этого требует matcher
        while (matcher.find()) {
            String quote = matcher.group(1);
            String oldImageUrl = matcher.group(3);
            if (isRelativeUrl(oldImageUrl))
                throw new RelativeUriNotSupportedException(oldImageUrl);
            String newImageUrl = imageUploader.uploadImage(oldImageUrl);
            matcher.appendReplacement(newCss, "url(" + quote + newImageUrl + quote + ")");
        }
        matcher.appendTail(newCss);
        return newCss.toString();
    }
}
