package ru.yandex.bannerstorage.harvester.queues.processdynamiccode.processors;

import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;

import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.exceptions.ExternalUriForbiddenException;
import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.infrastracture.ImageStorageService;

/**
 * @author egorovmv
 */
public class ElementWithForbiddenExternalUriProcessor extends ElementProcessor {
    private final String checkedAttributeName;

    public ElementWithForbiddenExternalUriProcessor(@NotNull String checkedAttributeName) {
        this.checkedAttributeName = checkedAttributeName;
    }

    @Override
    public void processElement(@NotNull Element element, @NotNull ImageStorageService.ImageUploader imageUploader) {
        if (!element.hasAttr(checkedAttributeName))
            return;
        String url = element.attr(checkedAttributeName).trim();
        if (url.length() > 0)
            throw new ExternalUriForbiddenException(url);
    }
}
