package ru.yandex.bannerstorage.harvester.queues.processdynamiccode.processors;

import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;

import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.infrastracture.ImageStorageService;

/**
 * @author egorovmv
 */
public final class ElementWithStyleAttributeProcessor extends ElementWithCssProcessor {
    @Override
    public void processElement(
            @NotNull Element element, @NotNull ImageStorageService.ImageUploader imageUploader) {
        if (!element.hasAttr("style"))
            return;
        String oldStyle = element.attr("style").trim();
        if (oldStyle.length() == 0)
            return;
        element.attr("style", processCss(oldStyle, imageUploader));
    }
}
