package ru.yandex.bannerstorage.harvester.queues.processdynamiccode.processors;

import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;

import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.exceptions.RelativeUriNotSupportedException;
import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.infrastracture.ImageStorageService;

/**
 * @author egorovmv
 */
public final class ImgElementProcessor extends ElementProcessor {
    @Override
    public void processElement(@NotNull Element element, @NotNull ImageStorageService.ImageUploader imageUploader) {
        if (!element.hasAttr("src"))
            return;
        String src = element.attr("src").trim();
        if (src.length() == 0)
            return;
        if (isRelativeUrl(src))
            throw new RelativeUriNotSupportedException(src);
        element.attr("src", imageUploader.uploadImage(src));
    }
}
