package ru.yandex.bannerstorage.harvester.queues.processdynamiccode.processors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Element;

import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.exceptions.ExternalUriForbiddenException;
import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.infrastracture.ImageStorageService;

/**
 * @author egorovmv
 */
public final class ScriptElementProcessor extends ElementProcessor {
    // TODO: Cледует доработать regexp так как по RFC-3986 в url-ле могут встречаться и ' и "
    private static final Pattern SOMETHING_LIKE_IMAGE_URL_PATTERN = Pattern.compile(
            "('|\")((?:https?:)?(?://)?(?:[^\\s'\"/]+/)+[^\\s'\"/.]+\\.(?:gif|png|jpg|jpeg))\\1");

    @Override
    public void processElement(
            @NotNull Element element, @NotNull ImageStorageService.ImageUploader imageUploader) {
        if (element.hasAttr("src")) {
            String src = element.attr("src").trim();
            if (src.length() > 0)
                throw new ExternalUriForbiddenException(src);
        }
        if (element.hasAttr("type")) {
            if (!element.attr("type").equalsIgnoreCase("text/javascript"))
                return;
        }
        for (DataNode dataNode : element.dataNodes()) {
            Matcher matcher = SOMETHING_LIKE_IMAGE_URL_PATTERN.matcher(dataNode.getWholeData());
            int matchCount = 0;
            StringBuffer newContent = new StringBuffer();
            while (matcher.find()) {
                String quote = matcher.group(1);
                String oldImageUrl = matcher.group(2);
                String newImageUrl = imageUploader.uploadImage(oldImageUrl);
                matcher.appendReplacement(newContent, quote + newImageUrl + quote);
                matchCount++;
            }
            if (matchCount > 0) {
                matcher.appendTail(newContent);
                dataNode.setWholeData(newContent.toString());
            }
        }
    }
}
