package ru.yandex.bannerstorage.harvester.queues.processdynamiccode.processors;

import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;

import ru.yandex.bannerstorage.harvester.queues.processdynamiccode.infrastracture.ImageStorageService;

/**
 * @author egorovmv
 */
public final class StyleElementProcessor extends ElementWithCssProcessor {
    @Override
    public void processElement(
            @NotNull Element element, @NotNull ImageStorageService.ImageUploader imageUploader) {
        if (element.hasAttr("type") && !element.attr("type").equalsIgnoreCase("text/css"))
            return;
        String oldContent = element.data();
        if (oldContent.length() == 0)
            return;
        element.text(processCss(oldContent, imageUploader));
    }
}
