package ru.yandex.bannerstorage.harvester.queues.rtbintegration.creativechanged.models;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang3.tuple.Pair;

/**
 * @author egorovmv
 */
public final class ChangedCreatives {
    private final List<DbCreative> list;
    private final Map<Integer, List<Integer>> tnsBrands;
    private final Map<Integer, List<Integer>> tnsArticles;
    private final Map<Integer, List<Integer>> geo;
    private final Map<Integer, List<Integer>> sites;
    private final Map<Integer, Map<String, ParameterValue>> parameters;
    private final Map<Integer, List<Pair<String, Integer>>> showItems;
    private final Map<Integer, Pair<String, String>> dspProps;

    public ChangedCreatives(
            List<DbCreative> list,
            Map<Integer, List<Integer>> tnsBrands,
            Map<Integer, List<Integer>> tnsArticles,
            Map<Integer, List<Integer>> geo,
            Map<Integer, List<Integer>> sites,
            Map<Integer, Map<String, ParameterValue>> parameters,
            Map<Integer, List<Pair<String, Integer>>> showItems,
            Map<Integer, Pair<String, String>> dspProps) {
        this.list = list;
        this.tnsBrands = tnsBrands != null ? tnsBrands : Collections.emptyMap();
        this.tnsArticles = tnsArticles != null ? tnsArticles : Collections.emptyMap();
        this.geo = geo != null ? geo : Collections.emptyMap();
        this.sites = sites != null ? sites : Collections.emptyMap();
        this.parameters = parameters != null ? parameters : Collections.emptyMap();
        this.showItems = showItems != null ? showItems : Collections.emptyMap();
        this.dspProps = dspProps != null ? dspProps : Collections.emptyMap();
    }

    @Override
    public String toString() {
        return "ChangedCreatives{" +
                "list=" + list +
                ", tnsBrands=" + tnsBrands +
                ", tnsArticles=" + tnsArticles +
                ", geo=" + geo +
                ", sites=" + sites +
                ", parameters=" + parameters +
                ", showItems=" + showItems +
                ", dspProps=" + dspProps +
                '}';
    }

    public List<DbCreative> getList() {
        return list;
    }

    public List<Integer> getTnsBrands(@NotNull Integer id) {
        return tnsBrands.getOrDefault(id, Collections.emptyList());
    }

    public List<Integer> getTnsArticles(@NotNull Integer id) {
        return tnsArticles.getOrDefault(id, Collections.emptyList());
    }

    public List<Integer> getGeo(@NotNull Integer id) {
        return geo.getOrDefault(id, Collections.emptyList());
    }

    public List<Integer> getSites(@NotNull Integer id) {
        return sites.getOrDefault(id, Collections.emptyList());
    }

    public Map<String, ParameterValue> getParameters(@NotNull Integer id) {
        return parameters.getOrDefault(id, Collections.emptyMap());
    }

    public List<Pair<String, Integer>> getShowItems(@NotNull Integer id) {
        return showItems.getOrDefault(id, Collections.emptyList());
    }

    public Pair<String, String> getDspProp(@NotNull Integer id) {
        return dspProps.get(id);
    }
}
