package ru.yandex.bannerstorage.harvester.queues.rtbintegration.creativechanged.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;

/**
 * Модель для одноимённого поля в модели креатива
 * При отправке в RTBHost эта модель сериализуется в JSON и отправляется в виде поля-строки
 * {@link ru.yandex.direct.bs.dspcreative.model.DspCreativeExportEntry#getConstructorData}.
 */
@JsonAutoDetect(fieldVisibility = NONE, getterVisibility = NONE, setterVisibility = NONE, isGetterVisibility = NONE, creatorVisibility = NONE)
public class ConstructorData {
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty("minWidth")
    private final Integer minWidth;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty("maxWidth")
    private final Integer maxWidth;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty("minHeight")
    private final Integer minHeight;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty("maxHeight")
    private final Integer maxHeight;
    @JsonProperty("isSmartTile")
    private final boolean isSmartTile;
    @JsonProperty("formatName")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private final String formatName;
    @JsonProperty("renderedParamValues")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private final String renderedParamValues;

    public ConstructorData(Integer minWidth, Integer maxWidth,
                           Integer minHeight, Integer maxHeight,
                           boolean isSmartTile, String formatName,
                           String renderedParamValues) {
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.isSmartTile = isSmartTile;
        this.formatName = formatName;
        this.renderedParamValues = renderedParamValues;
    }

    public Integer getMinWidth() {
        return minWidth;
    }

    public Integer getMaxWidth() {
        return maxWidth;
    }

    public Integer getMinHeight() {
        return minHeight;
    }

    public Integer getMaxHeight() {
        return maxHeight;
    }

    public boolean isSmartTile() {
        return isSmartTile;
    }

    public String getFormatName() {
        return formatName;
    }

    public String getRenderedParamValues() {
        return renderedParamValues;
    }
}
