package ru.yandex.bannerstorage.harvester.queues.rtbintegration.creativechanged.models;

import java.util.Date;

/**
 * Модель для получения информации о креативе из базы.
 */
public final class DbCreative {
    private Integer creativeId;
    private Integer creativeVersionId;
    private Integer templateId;
    private Integer codeId;
    private Integer customerId;
    private String customerName;
    private Integer dspId;
    private Integer width;
    private Integer height;
    private Date updateTime;
    private Date expireTime;
    private Date createTime;
    private boolean enabled;
    private String data;
    private String staticData;
    private boolean isVideo;
    private Integer orderNo;
    private String rtbTag;
    private Integer smartThemeId;
    private Integer smartSizeId;
    private Integer smartLayoutId;

    public Integer getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(Integer creativeId) {
        this.creativeId = creativeId;
    }

    public Integer getCreativeVersionId() {
        return creativeVersionId;
    }

    public void setCreativeVersionId(Integer creativeVersionId) {
        this.creativeVersionId = creativeVersionId;
    }

    public Integer getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Integer templateId) {
        this.templateId = templateId;
    }

    public Integer getCodeId() {
        return codeId;
    }

    public void setCodeId(Integer codeId) {
        this.codeId = codeId;
    }

    public Integer getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Integer customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Integer getDspId() {
        return dspId;
    }

    public void setDspId(Integer dspId) {
        this.dspId = dspId;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Date getUpdateTime() {
        return updateTime != null ? new Date(updateTime.getTime()) : null;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime != null ? new Date(expireTime.getTime()) : null;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime != null ? new Date(createTime.getTime()) : null;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getStaticData() {
        return staticData;
    }

    public void setStaticData(String staticData) {
        this.staticData = staticData;
    }

    public boolean isVideo() {
        return isVideo;
    }

    public void setVideo(boolean video) {
        this.isVideo = video;
    }

    public Integer getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(Integer orderNo) {
        this.orderNo = orderNo;
    }

    public String getRtbTag() {
        return rtbTag;
    }

    public void setRtbTag(String rtbTag) {
        this.rtbTag = rtbTag;
    }

    public Integer getSmartThemeId() {
        return smartThemeId;
    }

    public void setSmartThemeId(Integer smartThemeId) {
        this.smartThemeId = smartThemeId;
    }

    public Integer getSmartSizeId() {
        return smartSizeId;
    }

    public void setSmartSizeId(Integer smartSizeId) {
        this.smartSizeId = smartSizeId;
    }

    public Integer getSmartLayoutId() {
        return smartLayoutId;
    }

    public void setSmartLayoutId(Integer smartLayoutId) {
        this.smartLayoutId = smartLayoutId;
    }
}
