package ru.yandex.bannerstorage.harvester.queues.rtbintegration.creativechanged.models;

import java.util.Collections;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Значение параметра креатива.
 */
public final class ParameterValue {
    @JsonProperty("ParamName")
    private final String paramName;
    @JsonProperty("ParamType")
    private final String paramType;
    @JsonProperty("ParamValue")
    private final List<String> paramValues;
    @JsonIgnore
    private final Integer orderInList;

    public ParameterValue(
            String paramName, List<String> paramValues, Integer orderInList, String paramType) {
        this.paramName = paramName;
        this.paramType = paramType;
        this.paramValues = paramValues != null ? paramValues : Collections.emptyList();
        this.orderInList = orderInList;
    }

    @Override
    public String toString() {
        return "ParameterValue{" +
                "paramName='" + paramName + '\'' +
                ", paramType='" + paramType + '\'' +
                ", paramValues=" + paramValues +
                ", orderInList=" + orderInList +
                '}';
    }

    public String getParamName() {
        return paramName;
    }

    public String getParamType() {
        return paramType;
    }

    public List<String> getParamValues() {
        return paramValues;
    }

    public Integer getOrderInList() {
        return orderInList;
    }
}
