package ru.yandex.bannerstorage.harvester.queues.rtbintegration.creativechanged.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Модель для одноимённого поля в модели креатива
 * При отправке в RTBHost эта модель сериализуется в JSON и отправляется в виде поля-строки
 * {@link ru.yandex.direct.bs.dspcreative.model.DspCreativeExportEntry#getConstructorData}.
 */
public class VideoConstructorData {
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty("duration")
    private final Integer duration;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty("playbackParameters")
    private final PlaybackParameters playbackParameters;

    public VideoConstructorData(Integer duration, PlaybackParameters playbackParameters) {
        this.duration = duration;
        this.playbackParameters = playbackParameters;
    }

    public Integer getDuration() {
        return duration;
    }

    public PlaybackParameters getPlaybackParameters() {
        return playbackParameters;
    }
}
