package ru.yandex.bannerstorage.harvester.queues.rtbintegration.infrastructure;

import java.util.UUID;

import org.jetbrains.annotations.NotNull;

/**
 * @author egorovmv
 */
public final class RtbClientErrorException extends RuntimeException {
    private final boolean recoverable;

    public RtbClientErrorException(
            @NotNull UUID requestId, boolean recoverable, @NotNull Throwable cause) {
        super("RequestId: " + requestId, cause);
        this.recoverable = recoverable;
    }

    public boolean isRecoverable() {
        return recoverable;
    }
}
