package ru.yandex.bannerstorage.harvester.queues.rtbintegration.infrastructure.impl;

import java.net.URI;

import javax.validation.constraints.NotNull;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import ru.yandex.bannerstorage.harvester.utils.RestTemplateFactory;

import static java.util.Collections.singletonList;

public class BsApiClientService {
    private static final Logger logger = LoggerFactory.getLogger(BsApiClientService.class);

    private final RestTemplate restTemplate;
    private final URI apiUrl;

    public BsApiClientService(@NotNull RestTemplateFactory restTemplateFactory,
                              @NotNull String apiUrl) {
        this.restTemplate = restTemplateFactory.create(10_000, 30_000);
        this.apiUrl = URI.create(apiUrl);
    }

    // Идёт по ссылке вида
    // /page/4208605?token=a&version=6463474&need_wrap=0&use_prod=1&preview=0&code_from=CONSTRUCTOR_DATA_CODE
    // и получает там код
    public String getCode(int creativeId, int creativeVersionId, String codeParameter) {
        URI targetUrl = UriComponentsBuilder.fromUri(apiUrl)
                .pathSegment("page", Integer.toString(creativeId))
                .queryParam("token", "a")
                .queryParam("version", creativeVersionId)
                .queryParam("need_wrap", 0)
                .queryParam("use_prod", 1)
                .queryParam("preview", 0)
                .queryParam("code_from", codeParameter)
                .build()
                .toUri();

        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(singletonList(MediaType.APPLICATION_JSON));

        try {
            logger.info("Sending request for creative {}: {}", creativeId, targetUrl);

            ResponseEntity<String> responseEntity = restTemplate.exchange(
                    targetUrl,
                    HttpMethod.GET,
                    new HttpEntity<>(headers),
                    String.class);

            String response = responseEntity.getBody();

            logger.info("Got response for creative {}: {}", creativeId, response);

            return response;
        } catch (ResourceAccessException | HttpStatusCodeException e) {
            throw new BsApiClientException("Error getting code from BS API", e);
        }
    }
}
