package ru.yandex.bannerstorage.harvester.queues.rtbintegration.infrastructure.impl;

import java.util.Objects;

import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcTemplate;

import ru.yandex.bannerstorage.harvester.queues.rtbintegration.infrastructure.RtbIntegrationHealthService;

/**
 * @author egorovmv
 */
public final class JdbcRtbIntegrationHealthService implements RtbIntegrationHealthService {
    private final JdbcTemplate jdbcTemplate;

    public JdbcRtbIntegrationHealthService(@NotNull JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate, "jdbcTemplate");
    }

    @Override
    public void notifyAlive(@NotNull Queue queue) {
        Objects.requireNonNull(queue, "queue");
        switch (queue) {
            case CREATIVE_CHANGED:
                jdbcTemplate.update(
                        "UPDATE dbo.t_rtbhostlink_state" +
                                " SET creative_change_notifier_last_sent_time = GETDATE()");
                break;

            case RECV_UNMODERATED_ASSEMBLIES:
                jdbcTemplate.update(
                        "UPDATE dbo.t_rtbhostlink_state" +
                                " SET assembly_object_collector_last_recv_time = GETDATE()");
                break;

            case SEND_MODERATED_OFFERS:
                jdbcTemplate.update(
                        "UPDATE dbo.t_rtbhostlink_state" +
                                " SET assembly_object_moderation_notifier_last_sent_time = GETDATE()");
                break;

            default:
                throw new AssertionError(queue.toString());
        }
    }
}
