package ru.yandex.bannerstorage.harvester.queues.rtbintegration.postmoderation.models;

import java.util.Map;
import java.util.Objects;

import javax.validation.constraints.NotNull;

/**
 * Предвыворные отображения идентификаторов креативов сборок в идентификаторы
 * последних версий креативов и идентификаторов версий креативов сборок в идентификаторы креативов
 *
 * @author egorovmv
 */
public final class AssemblyCreativeMaps {
    private final Map<Integer, Integer> creativeIdToVersionId;
    private final Map<Integer, Integer> versionIdToCreativeId;

    public AssemblyCreativeMaps(
            @NotNull Map<Integer, Integer> creativeIdToVersionId,
            @NotNull Map<Integer, Integer> versionIdToCreativeId) {
        this.creativeIdToVersionId = Objects.requireNonNull(creativeIdToVersionId, "creativeIdToVersionId");
        this.versionIdToCreativeId = Objects.requireNonNull(versionIdToCreativeId, "versionIdToCreativeId");
    }

    public Integer getVersionId(@NotNull Integer creativeId) {
        return creativeIdToVersionId.get(creativeId);
    }

    public Integer getCreativeId(@NotNull Integer versionId) {
        return versionIdToCreativeId.get(versionId);
    }
}
