package ru.yandex.bannerstorage.harvester.queues.rtbintegration.postmoderation.models;

import java.sql.Timestamp;
import java.util.Objects;

import javax.validation.constraints.NotNull;

/**
 * Сборка
 *
 * @author egorovmv
 */
public final class AssemblyInfo {
    private final int queueId;
    private final int creativeId;
    private final Integer creativeVersionId;
    private final String bidReqId;
    private final Timestamp bidReqTime;
    private final Integer regionId;
    private final long creativeHits;
    private final Timestamp lastKnownImpression;
    private final Integer numberOfImpressions;
    private final Timestamp enqueued;
    private final Integer width;
    private final Integer height;

    public AssemblyInfo(
            @NotNull Integer queueId,
            @NotNull Integer creativeId,
            Integer creativeVersionId,
            String bidReqId,
            Timestamp bidReqTime,
            Integer regionId,
            Long creativeHits,
            Timestamp lastKnownImpression,
            Integer numberOfImpressions,
            Timestamp enqueued,
            Integer width,
            Integer height) {
        Objects.requireNonNull(queueId, "queueId");
        Objects.requireNonNull(creativeId, "creativeId");
        Objects.requireNonNull(enqueued, "enqueued");

        this.queueId = queueId;
        this.creativeId = creativeId;
        this.creativeVersionId = creativeVersionId;
        this.bidReqId = bidReqId;
        this.bidReqTime = bidReqTime;
        this.regionId = regionId;
        this.creativeHits = creativeHits != null ? creativeHits : 1;
        this.lastKnownImpression = lastKnownImpression;
        this.numberOfImpressions = numberOfImpressions != null ? numberOfImpressions : 0;
        this.enqueued = enqueued;
        this.width = width;
        this.height = height;
    }

    @Override
    public String toString() {
        return "AssemblyInfo{" +
                "queueId=" + queueId +
                ", creativeId=" + creativeId +
                ", creativeVersionId=" + creativeVersionId +
                ", bidReqId=" + bidReqId +
                ", bidReqTime=" + bidReqTime +
                ", regionId=" + regionId +
                ", creativeHits=" + creativeHits +
                ", lastKnownImpression=" + lastKnownImpression +
                ", numberOfImpressions=" + numberOfImpressions +
                ", enqueued=" + enqueued +
                ", width=" + width +
                ", height=" + height +
                '}';
    }

    public int getQueueId() {
        return queueId;
    }

    public int getCreativeId() {
        return creativeId;
    }

    public Integer getCreativeVersionId() {
        return creativeVersionId;
    }

    public String getBidReqId() {
        return bidReqId;
    }

    public Timestamp getBidReqTime() {
        return bidReqTime;
    }

    public Integer getRegionId() {
        return regionId;
    }

    public long getCreativeHits() {
        return creativeHits;
    }

    public Timestamp getLastKnownImpression() {
        return lastKnownImpression;
    }

    public Integer getNumberOfImpressions() {
        return numberOfImpressions;
    }

    public Timestamp getEnqueued() {
        return enqueued;
    }

    public Integer getWidth() {
        return width;
    }

    public Integer getHeight() {
        return height;
    }
}
