package ru.yandex.bannerstorage.harvester.queues.rtbintegration.postmoderation.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author egorovmv
 */
public final class CreativeInfo {
    private final Integer id;
    private final Integer versionId;
    private final Long hits;

    @JsonCreator
    public CreativeInfo(
            @JsonProperty("ID") Integer id,
            @JsonProperty("VersionID") Integer versionId,
            @JsonProperty("Hits") Long hits) {
        this.id = id;
        this.versionId = versionId;
        this.hits = hits;
    }

    @Override
    public String toString() {
        return "CreativeInfo{" +
                "id=" + id +
                ", versionId=" + versionId +
                ", hits=" + hits +
                '}';
    }

    public Integer getId() {
        return id;
    }

    public Integer getVersionId() {
        return versionId;
    }

    public Long getHits() {
        return hits;
    }
}
