package ru.yandex.bannerstorage.harvester.queues.rtbintegration.postmoderation.models;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author egorovmv
 */
public final class DcParams {
    private final Map<String, Map<String, Object>> dataParams;
    private final Map<String, Object> creativeParams;

    @JsonCreator
    public DcParams(
            @JsonProperty(value = "data_params", required = true) @NotNull Map<String, Map<String, Object>> dataParams,
            @JsonProperty(UnmoderatedOffer.CreativeParamsKeyName) Map<String, Object> creativeParams) {
        this.dataParams = Objects.requireNonNull(dataParams, "dataParams");
        this.creativeParams = creativeParams;
    }

    @Override
    public String toString() {
        return "DcParams{" +
                "dataParams=" + dataParams +
                ", creativeParams=" + creativeParams +
                '}';
    }

    public Map<String, Map<String, Object>> toMap() {
        if (creativeParams == null)
            return dataParams;
        Map<String, Map<String, Object>> result = new HashMap<>(dataParams);
        result.put(UnmoderatedOffer.CreativeParamsKeyName, creativeParams);
        return result;
    }
}
