package ru.yandex.bannerstorage.harvester.queues.rtbintegration.postmoderation.models;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author egorovmv
 */
public final class ModeratedOffer {
    @JsonIgnore
    private int objectId;
    @JsonProperty("DataMD5")
    private String hashId;
    @JsonProperty("Checked")
    private boolean checked;
    @JsonProperty("Enabled")
    private boolean enabled;
    @JsonProperty("ModeratorComment")
    private String moderatorComment;
    @JsonProperty("ModerationResults")
    private List<RejectReason> reasons;

    @Override
    public String toString() {
        return "ModeratedOffer{" +
                "objectId=" + objectId +
                ", hashId='" + hashId + '\'' +
                ", checked=" + checked +
                ", enabled=" + enabled +
                ", moderatorComment='" + moderatorComment + '\'' +
                ", reasons=" + reasons +
                '}';
    }

    public int getObjectId() {
        return objectId;
    }

    public void setObjectId(int objectId) {
        this.objectId = objectId;
    }

    public String getHashId() {
        return hashId;
    }

    public void setHashId(String hashId) {
        this.hashId = hashId;
    }

    public boolean isChecked() {
        return checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getModeratorComment() {
        return moderatorComment != null ? moderatorComment : "";
    }

    public void setModeratorComment(String moderatorComment) {
        this.moderatorComment = moderatorComment;
    }

    public List<RejectReason> getReasons() {
        return reasons;
    }

    public void setReasons(List<RejectReason> reasons) {
        this.reasons = reasons;
    }
}
