package ru.yandex.bannerstorage.harvester.queues.rtbintegration.postmoderation.models;

import java.util.Objects;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Немодерированный offer
 *
 * @author egorovmv
 */
public final class UnmoderatedOffer {
    public static final String CreativeParamsKeyName = "creative_params";

    private final int objectType;
    private final String keyName;
    private final String hashId;
    private final String dspObjectId;
    private final boolean checked;
    private final long hits;
    private final boolean moderationRequired;

    public UnmoderatedOffer(
            @JsonProperty("ObjectType") @NotNull Integer objectType,
            @JsonProperty("KeyName") @NotNull String keyName,
            @JsonProperty("DataMD5") @NotNull String hashId,
            @JsonProperty("ObjectID") @NotNull String dspObjectId,
            @JsonProperty("Checked") @NotNull Boolean checked,
            @JsonProperty("Hits") Long hits,
            @JsonProperty("PreModerated") Boolean premoderated) {
        Objects.requireNonNull(objectType, "objectType");
        Objects.requireNonNull(keyName, "keyName");
        Objects.requireNonNull(hashId, "hashId");
        Objects.requireNonNull(checked, "checked");

        this.objectType = objectType;
        this.keyName = objectType == 1 ? keyName : CreativeParamsKeyName;
        this.hashId = hashId;
        this.dspObjectId = dspObjectId != null ? dspObjectId : "";
        this.checked = checked;
        this.hits = hits != null ? hits : 1;
        // Берем, только объекты с objectType == 1 и среди них модерируем только то что еще не премодерировано
        this.moderationRequired = !(premoderated != null ? premoderated : false) && objectType == 1;
    }

    @Override
    public String toString() {
        return "UnmoderatedOffer{" +
                "objectType=" + objectType +
                ", keyName='" + keyName + '\'' +
                ", hashId='" + hashId + '\'' +
                ", dspObjectId='" + dspObjectId + '\'' +
                ", checked=" + checked +
                ", hits=" + hits +
                ", moderationRequired=" + moderationRequired +
                '}';
    }

    public int getObjectType() {
        return objectType;
    }

    public String getKeyName() {
        return keyName;
    }

    public String getHashId() {
        return hashId;
    }

    public String getDspObjectId() {
        return dspObjectId;
    }

    public boolean isChecked() {
        return checked;
    }

    public long getHits() {
        return hits;
    }

    public boolean isModerationRequired() {
        return moderationRequired;
    }
}
