package ru.yandex.bannerstorage.harvester.queues.rtbintegration.postmoderation.services;

import java.util.List;
import java.util.Map;

import javax.validation.constraints.NotNull;

import ru.yandex.bannerstorage.harvester.queues.rtbintegration.postmoderation.models.AssemblyCreativeMaps;
import ru.yandex.bannerstorage.harvester.queues.rtbintegration.postmoderation.models.AssemblyInfo;
import ru.yandex.bannerstorage.harvester.queues.rtbintegration.postmoderation.models.ModeratedOffer;
import ru.yandex.bannerstorage.harvester.queues.rtbintegration.postmoderation.models.UnmoderatedOffer;

/**
 * @author egorovmv
 */
public interface AssemblyService {
    @NotNull
    Integer getLatestQueueId();

    @NotNull
    AssemblyCreativeMaps getAssemblyCreativeMaps(
            @NotNull List<Integer> creativeIds, @NotNull List<Integer> creativeVersionIds);

    Integer persistAssembly(@NotNull AssemblyInfo assembly, @NotNull Integer creativeVersionId);

    void persistOffer(
            @NotNull Integer assemblyId,
            @NotNull UnmoderatedOffer offer,
            @NotNull Map<String, Object> offerDcParams,
            int orderNo);

    @NotNull
    List<ModeratedOffer> getUnsyncModeratedOffers(int fetchCount);

    void markOffersAsSync(@NotNull List<Integer> objectIds);
}
