package ru.yandex.bannerstorage.harvester.tardis.infrastracture;

import ru.yandex.bannerstorage.harvester.tardis.models.vh.CreatedDirectory;
import ru.yandex.bannerstorage.harvester.tardis.models.vh.CreatedTask;
import ru.yandex.bannerstorage.harvester.tardis.models.vh.Directory;
import ru.yandex.bannerstorage.harvester.tardis.models.vh.Task;

public interface VhClient {
    /**
     * Метод создает директорию в S3 для дальнейшей загрузки контента
     *
     * @param directory - директория, которую нужно создать
     * @return возвращает созданную директорию
     */
    CreatedDirectory createDirectory(Directory directory);

    /**
     * Создает таск на конвертацию в видеохостинг
     *
     * @param vhTask - таск для видео, которое нужно отконвертировать
     * @return вовзращает созданный таск
     */
    CreatedTask uploadVideo(Task vhTask);

    /**
     * Проверяет статус выполнения конвертации для переданого uuid
     *
     * @param uuid - идентификатор таска, для которого нужно проверить статус
     * @return вовзращает таск с данным uuid
     */
    CreatedTask checkStatus(String uuid);
}
