package ru.yandex.bannerstorage.harvester.tardis.models;

/**
 * Информация о новом файле
 *
 * @author freakbelka
 */
public class NewFileInfo implements FileInfo {
    private int fileCdnNmb;
    /**
     * Номер файла
     */
    private final int nmb;
    private int width;
    private int height;
    /**
     * Данные CDN'а
     */
    private final CdnInfo cdn;
    /**
     * Урл файла из Stillage
     */
    private final String stillageFileUrl;

    public NewFileInfo(int fileCdnNmb, int nmb, int cdnNmb, String cdnName, String uploadUrl, String stillageFileUrl,
            int width, int height)
    {
        this.fileCdnNmb = fileCdnNmb;
        this.nmb = nmb;
        this.width = width;
        this.height = height;
        this.cdn = new CdnInfo(cdnNmb, cdnName, uploadUrl);
        this.stillageFileUrl = stillageFileUrl;
    }

    @Override
    public int getNmb() {
        return nmb;
    }

    public String getStillageFileUrl() {
        return stillageFileUrl;
    }

    @Override
    public CdnInfo getCdn() {
        return cdn;
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    public int getFileCdnNmb() {
        return fileCdnNmb;
    }
}
