package ru.yandex.bannerstorage.harvester.tardis.models;

import java.sql.Timestamp;

public class PendingFileInfo implements FileInfo {

    private int fileCdnNmb;
    private int nmb;
    private int width;
    private int height;
    private final CdnInfo cdn;
    private String url;
    private Timestamp processingStarted;

    public PendingFileInfo(int fileCdnNmb, int nmb, int cdnNmb, String cdnName, String uploadUrl, String url, int width,
            int height, Timestamp processingStarted)
    {
        this.fileCdnNmb = fileCdnNmb;
        this.nmb = nmb;
        this.width = width;
        this.height = height;
        this.cdn = new CdnInfo(cdnNmb, cdnName, uploadUrl);
        this.url = url;
        this.processingStarted = processingStarted;
    }

    @Override
    public int getNmb() {
        return nmb;
    }

    @Override
    public CdnInfo getCdn() {
        return cdn;
    }

    public String getUrl() {
        return url;
    }

    public int getWidth() {
        return width;
    }

    @Override
    public int getHeight() {
        return height;
    }

    public int getFileCdnNmb() {
        return fileCdnNmb;
    }

    public Timestamp getProcessingStarted() {
        return processingStarted;
    }
}
