package ru.yandex.bannerstorage.harvester.tardis.models.vh;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class ContentVersions {
    @JsonProperty("input_streams")
    private List<InputStream> inputStreams;

    @JsonProperty("output_streams")
    private List<OutputStream> outputStreams;

    @JsonProperty("type")
    private String type;

    @JsonCreator
    public ContentVersions(@JsonProperty("input_streams") @NotNull List<InputStream> inputStreams,
            @JsonProperty("output_streams") @Nullable List<OutputStream> outputStreams,
            @JsonProperty("type") @Nullable String type)
    {
        this.inputStreams = inputStreams;
        this.outputStreams = outputStreams;
        this.type = type;
    }

    @Override
    public String toString() {
        return "ContentVersions{" +
                "input_streams=" + inputStreams +
                ", output_streams=" + outputStreams +
                ", type=" + type +
                '}';
    }

    public List<InputStream> getInputStreams() {
        return inputStreams;
    }

    public List<OutputStream> getOutputStreams() {
        return outputStreams;
    }

    public String getType() {
        return type;
    }
}
