package ru.yandex.bannerstorage.harvester.tardis.models.vh;

import java.util.List;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

public class CreatedTask {

    private String uuid;
    private List<ContentVersions> contentVersions;
    private String thumbnail;

    public CreatedTask(@JsonProperty("uuid") @NotNull String uuid,
            @JsonProperty("content_versions") @NotNull List<ContentVersions> contentVersions,
            @JsonProperty("thumbnail") @Nullable String thumbnail)
    {
        this.uuid = uuid;
        this.contentVersions = contentVersions;
        this.thumbnail = thumbnail;
    }

    public String getUuid() {
        return uuid;
    }

    public List<ContentVersions> getContentVersions() {
        return contentVersions;
    }

    public String getThumbnail() {
        return thumbnail;
    }
}
